local Entity = require("entity")

---@class Scope
---@field __type "Scope"
---@field parent nil|Scope
---@field declarations table<string, Entity>
---@field defers Node[]
local Scope = {}
Scope.__index = Scope
Scope.__type = "Scope"
---cria um novo escope/ambiente
---@param parent ?Scope
---@return Scope
function Scope.new(parent)
    return setmetatable({
        parent = parent,
        declarations = {},
        defers = {}
    }, Scope)
end
---isso faz uma nova declaração
---@param name string
---@param value Entity
function Scope:makeNewDeclaration(name, value)
    --essa checagem é para ter um bloqueio em declarações com o mesmo nome no mesmo escopo
    if self.declarations[name] then
        return false
    end

    self.declarations[name] = value
    return true
end
---aqui é onde faz a busca de variaveis
---a busca é feita de dentro para fora, do escopo mais interno para o mais externo, do atual para o escopo pai
---@param name string
---@return nil|Entity
function Scope:getDeclaration(name)
    local current = self
    while current do
        local value = current.declarations[name]
        if value then
            return value
        end

        current = current.parent
    end
    return nil
end
---aqui vai reatribuir um novo valor a declaração
---@param name string
---@param value Entity
---@return boolean
function Scope:setDeclaration(name, value)
    local current = self
    while current do
        if current.declarations[name] then
            current.declarations[name] = value
            return true
        end

        current = current.parent
    end
    return false
end
---aqui é a declaração de um defer, isso agenta a execução para quando o evaluator sair do bloco
---@param node Node
function Scope:declareDefer(node)
    table.insert(self.defers, node)
end
---aqui é onde desenpilho os defer, começando de baixo para cima
---@return nil|Node
function Scope:popDefer()
    return table.remove(self.defers)
end
return Scope